/**************************************
*                                     *
*   Jeff Molofee's Basecode Example   *
*          nehe.gamedev.net           *
*                2001                 *
*                                     *
**************************************/

#include <windows.h>											// Header File For Windows
#include <gl\gl.h>												// Header File For The OpenGL32 Library
#include <gl\glu.h>												// Header File For The GLu32 Library
#include <gl\glaux.h>											// Header File For The GLaux Library
#include "NeHeGL.h"												// Header File For NeHeGL

#include "stdlib.h"
#include "stdio.h"

#pragma comment( lib, "opengl32.lib" )							// Search For OpenGL32.lib While Linking
#pragma comment( lib, "glu32.lib" )								// Search For GLu32.lib While Linking
#pragma comment( lib, "glaux.lib" )								// Search For GLaux.lib While Linking

#ifndef CDS_FULLSCREEN											// CDS_FULLSCREEN Is Not Defined By Some
#define CDS_FULLSCREEN 4										// Compilers. By Defining It This Way,
#endif															// We Can Avoid Errors

GL_Window*	g_window;
Keys*		g_keys;

// User Defined Variables
float		angle;												// Used To Rotate The Triangles
int			rot1, rot2;											// Counter Variables

float fovy;
float Gratio;
float zNear;
float zFar;

int WindowWidth;
int WindowHeight;


BOOL Initialize (GL_Window* window, Keys* keys)					// Any GL Init Code & User Initialiazation Goes Here
{
	g_window	= window;
	g_keys		= keys;

	// Start Of User Initialization
	angle		= 0.0f;											// Set Starting Angle To Zero

	glClearColor (0.0f, 0.0f, 0.0f, 0.5f);						// Black Background
	glClearDepth (1.0f);										// Depth Buffer Setup
	glDepthFunc (GL_LEQUAL);									// The Type Of Depth Testing (Less Or Equal)
	glEnable (GL_DEPTH_TEST);									// Enable Depth Testing
	glShadeModel (GL_SMOOTH);									// Select Smooth Shading
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);			// Set Perspective Calculations To Most Accurate

	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glPixelStorei(GL_PACK_ALIGNMENT, 1);

	return TRUE;												// Return TRUE (Initialization Successful)
}

void Deinitialize (void)										// Any User DeInitialization Goes Here
{
}

void Update (DWORD milliseconds)								// Perform Motion Updates Here
{
	if (g_keys->keyDown [VK_ESCAPE] == TRUE)					// Is ESC Being Pressed?
	{
		TerminateApplication (g_window);						// Terminate The Program
	}

	if (g_keys->keyDown [VK_F1] == TRUE)						// Is F1 Being Pressed?
	{
		ToggleFullscreen (g_window);							// Toggle Fullscreen Mode
	}

	angle += (float)(milliseconds) / 5.0f;						// Update angle Based On The Clock
}

#define PixelAt(x,y) ((WindowWidth * y) + x)



void applyFireFilter(GLfloat *winData){
	
	/*char str[512];
	sprintf(str, "%d - %d", WindowWidth, WindowHeight);
	MessageBoxA(NULL,str, "Info", MB_OK);
	*/
	int off = 0;
	for(int y=3; y < WindowHeight; y++){	
		off = y*WindowWidth*3;
		for(int x=0; x < WindowWidth; x++){		
		
			GLfloat varR = winData[(off+0)-3]   + winData[(off+0)+3] +
					   winData[((off+0)-1*WindowWidth*3)-3] + winData[((off+0)-1*WindowWidth*3)+0] + winData[((off+0)-1*WindowWidth*3)+3] +
					   winData[((off+0)-2*WindowWidth*3)-3] + winData[((off+0)-2*WindowWidth*3)+0] + winData[((off+0)-2*WindowWidth*3)+3] ;
            GLfloat varG = winData[(off+1)-3]   + winData[(off+1)+3] +
					   winData[((off+1)-1*WindowWidth*3)-3] + winData[((off+1)-1*WindowWidth*3)+1] + winData[((off+1)-1*WindowWidth*3)+3] +
					   winData[((off+1)-2*WindowWidth*3)-3] + winData[((off+1)-2*WindowWidth*3)+1] + winData[((off+1)-2*WindowWidth*3)+3] ;
            GLfloat varB = winData[(off+2)-3]   + winData[(off+2)+3] +
					   winData[((off+2)-1*WindowWidth*3)-3] + winData[((off+2)-1*WindowWidth*3)+2] + winData[((off+2)-1*WindowWidth*3)+3] +
					   winData[((off+2)-2*WindowWidth*3)-3] + winData[((off+2)-2*WindowWidth*3)+2] + winData[((off+2)-2*WindowWidth*3)+3] ;
            

			/*
			GLfloat varR = winData[off+0];
			GLfloat varG = winData[off+1];
			GLfloat varB = winData[off+2];
            */

			varR = varR / 8.1f;
			//if (varR>0) varR--;
			varG = varG / 8.1f;
			//if (varG>0) varG--;
			varB = varB / 8.1f;
			//if (varB>0) varB--;
			winData[off+0] = varR;
			winData[off+1] = varG;
			winData[off+2] = varB;

			//int var = winData[PixelAt(x-1,y)];
            

			//int var = winData[PixelAt(x,y)] << 3;
			//if (var>0) var--;
			//winData[PixelAt(x,y)] = winData[PixelAt(x,y)]+0.01;
			//winData[PixelAt(x,y)+1] = winData[PixelAt(x,y)]+0.01;
			//winData[PixelAt(x,y)+2] = winData[PixelAt(x,y)]+0.01;

			off += 3;
			

		}
	}

	return;
}

void Draw (void)
{
	glClear (/*GL_COLOR_BUFFER_BIT | */GL_DEPTH_BUFFER_BIT);		// Clear Screen And Depth Buffer
	glLoadIdentity ();											// Reset The Modelview Matrix
	glTranslatef (0.0f, 0.0f, -6.0f);							// Translate 6 Units Into The Screen
	glRotatef (angle, 0.0f, 1.0f, 0.0f);						// Rotate On The Y-Axis By angle

	for (rot1=0; rot1<2; rot1++)								// 2 Passes
	{
		glRotatef(90.0f,0.0f,1.0f,0.0f);						// Rotate 90 Degrees On The Y-Axis
		glRotatef(180.0f,1.0f,0.0f,0.0f);						// Rotate 180 Degress On The X-Axis
		for (rot2=0; rot2<2; rot2++)							// 2 Passes
		{
			glRotatef(180.0f,0.0f,1.0f,0.0f);					// Rotate 180 Degrees On The Y-Axis
			glBegin (GL_TRIANGLES);								// Begin Drawing Triangles
				glColor3f (1.f, 0.f, 0.f);	glVertex3f( 0.0f, 1.0f, 0.0f);
				glColor3f (0.f, 1.f, 0.f);	glVertex3f(-1.0f,-1.0f, 1.0f);
				glColor3f (0.f, 0.f, 1.f);	glVertex3f( 1.0f,-1.0f, 1.0f);
			glEnd ();											// Done Drawing Triangles
		}
	}

	// Generate The Texture	
	

	int winSize = WindowWidth * WindowHeight * 3 * sizeof(GLfloat);

	GLfloat *winData = new GLfloat[winSize];

	glReadPixels(0,0,WindowWidth,WindowHeight,GL_RGB, GL_FLOAT, winData);

	applyFireFilter(winData);	

	//glRasterPos2f(0.0f,0.0f);
	glDrawPixels(WindowWidth,WindowHeight,GL_RGB, GL_FLOAT, winData);

	delete[] winData;

	glFlush ();													// Flush The GL Rendering Pipeline
}
